/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectPlaceMessage
implements IMessage {
    private BlockState state;
    private BlockPos pos;
    private ItemStack stack;

    public DirectPlaceMessage() {
    }

    public DirectPlaceMessage(BlockState state, BlockPos pos, ItemStack stack) {
        this.state = state;
        this.pos = pos;
        this.stack = stack;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.state = Block.func_196257_b((int)buf.readInt());
        this.pos = buf.func_179259_c();
        this.stack = buf.func_150791_c();
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(Block.func_196246_j((BlockState)this.state));
        buf.func_179255_a(this.pos);
        buf.func_150788_a(this.stack);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayerEntity player = ctxIn.getSender();
        World world = player.func_130014_f_();
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, this.pos);
        if (colony == null && this.state.func_177230_c() == ModBlocks.blockHutTownHall || colony != null && colony.getPermissions().hasPermission((PlayerEntity)player, Action.MANAGE_HUTS)) {
            IBuilding building;
            CompoundNBT compound = this.stack.func_77978_p();
            if (colony != null && compound != null && compound.func_74764_b("colony") && colony.getID() != compound.func_74762_e("colony")) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.gui.buildtool.wrongcolony", (Object[])new Object[]{compound.func_74762_e("colony")});
                return;
            }
            player.func_130014_f_().func_175656_a(this.pos, this.state);
            InventoryUtils.reduceStackInItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), this.stack);
            this.state.func_177230_c().func_180633_a(world, this.pos, this.state, (LivingEntity)player, this.stack);
            if (compound != null && compound.func_74764_b("otherLevel") && (building = colony.getBuildingManager().getBuilding(this.pos)) != null) {
                building.setBuildingLevel(compound.func_74762_e("otherLevel"));
            }
        }
    }
}

